///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *	Contains a time information class.
 *	\file		IceTimeInfo.h
 *	\author		Pierre Terdiman
 *	\date		April, 4, 2000
 */
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Include Guard
#ifndef __ICETIMEINFO_H__
#define __ICETIMEINFO_H__

	// Cycle limit
	__forceinline	udword ClampFrameIndex(udword frameindex, udword limit, bool cycle)
					{
						if(cycle)	return frameindex % limit;
						else		return frameindex < limit ? frameindex : limit - 1;
					}

	class ICECORE_API TimeInfo
	{
		public:
		// Constructor/Destructor
										TimeInfo();
										~TimeInfo();
		// Time management
						void			UpdateGlobalTime(float relativetime);
		// Static time information
						float			mDeltaTM;				//!< Time between two frames (say 1.0f/30.0f)
		// Dynamic time information
						udword			mGlobalFrameCounter;	//!< Current global frame number (a.k.a. time stamp)
						float			mRelativeTime;			//!< Elapsed time since last frame
						float			mGlobalTime;			//!< Global time reference
						float			mt;						//!< Interpolation coeff between two frames (0.0f => 1.0f)
	};

#endif // __ICETIMEINFO_H__
